using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Net;
using System.Text;
using System.Windows.Forms;
using KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary; //Used by SearchDeviceManager and DeviceDescriptionManager
using KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionNS;
using KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.DeviceDescriptionSettingNS;
using KONICAMINOLTA.OpenAPISDK.SequenceCommonLibrary.IF.ResultStatusNS;

namespace OpenAPI_App_Manager
{
    public partial class frmMFPManagement : Form
    {
        private MFPConfig MFPCurrent;
        public  delegate void WaitDialogHandler();
        //public static event  WaitDialogHandler WaitDialogClosed;
        public MFPConfig MFP
        {
            get
            {
                return MFPCurrent;
            }
            set
            {
                this.MFPCurrent = value;
                this.MFPCurrent.QueryMFP();
                this.OpenAPIHandler.MFP = this.MFPCurrent;
                SetHandlerToControls();
            }
        }

        private AppSettings CurrentSettings;        
        public OpenAPIWrapper OpenAPIHandler;

        public frmMFPManagement()
        {
        }
        
        //frmMain is the entry point of our application
        public frmMFPManagement(MFPConfig mfp, AppSettings Settings)
        {
            InitializeComponent();

            this.MFPCurrent = mfp;
            this.CurrentSettings = Settings;

            this.Text = MFPCurrent.DisplayModel + " (" + MFPCurrent.Address + ")";

            OpenAPIHandler = new OpenAPIWrapper(MFPCurrent);

            //Set OpenAPIHandler in UserControls
            SetHandlerToControls();
        }

        private void SetHandlerToControls()
        {
            if (this.OpenAPIHandler.IsDeviceAlive() == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
            {
                appManager.OpenAPIHandler = this.OpenAPIHandler;
                pswcBrowser.OpenAPIHandler = this.OpenAPIHandler;
                mfpDetails.OpenAPIHandler = this.OpenAPIHandler;
                mfpActions.OpenAPIHandler = this.OpenAPIHandler;
            }
            //else
            //{
            //    MessageBox.Show("Unable to communicate with MFP", "Communication error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            //    //
            //}
        }
    }        
}